!!ARBfp1.0

ATTRIB iColor = fragment.color.primary;
#ATTRIB iColorSec = fragment.color.secondary;
ATTRIB iCoord = fragment.texcoord;
#ATTRIB iCoordFog = fragment.fogcoord;
#ATTRIB iPosition = fragment.position;

PARAM waveparam = program.local[0]; # x: phase; y: quality; z: scale;

OUTPUT oColor = result.color;
#OUTPUT oDepth = result.depth;

#---------#
# Program #
#---------#

# compute wave coord
TEMP wave;
MUL wave, waveparam.x, 180.0;
TEMP quality;
MOV quality, waveparam.y;
TEMP size;
MOV size, waveparam.z;
TEMP pos;
MOV pos, iCoord;
TEMP tmp;
TEMP pi;
MOV pi, 3.1415926535897932384626433832795;

MUL tmp, iCoord.x, quality;
ADD tmp, tmp, wave;
SIN tmp, tmp.w;
MUL tmp, tmp, pi;
MUL tmp, tmp, size;
ADD tmp, iCoord, tmp;
MOV pos.x, tmp.x;

MUL tmp, iCoord.y, quality;
ADD tmp, tmp, wave;
COS tmp, tmp.w;
MUL tmp, tmp, pi;
MUL tmp, tmp, size;
ADD tmp, iCoord, tmp;
MOV pos.y, tmp.y;

# mix texture & primary color
TEMP samp;
TXP samp, pos, texture, 2D;
TEMP out;
MUL out, samp, iColor;

# set output
MOV oColor, out;

END